/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;

public final class Armory {
    public static final String DICT_KEY_ARMOR = "itemArmor";
    public static final String DICT_KEY_HELMET = "itemHelmet";
    public static final String DICT_KEY_BOOTS = "itemBoots";
    public static final String DICT_KEY_CHESTPLATE = "itemChestplate";
    public static final String DICT_KEY_LEGGINGS = "itemLeggings";
    public static final String DICT_KEY_SHIELD = "itemShield";
    private static boolean _DICT_IDS_INITED = false;
    private static final DecimalFormat _VALFMT = ItemStack.field_111284_a;
    private static final int _HIDE_ATTRS_TOOLTIP_BIT = 2;
    private static final EntityEquipmentSlot[] _MAINHAND_ONLY = new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND};

    private static final void register(Item item, String key1, String key2) {
        if (SharedGlue.isDefined(item)) {
            ItemStack any = new ItemStack(item, 1, Short.MAX_VALUE);
            OreDictionary.registerOre((String)key1, (ItemStack)any);
            OreDictionary.registerOre((String)key2, (ItemStack)any);
        }
    }

    public static final void registerSharedDictIds() {
        int i;
        if (_DICT_IDS_INITED) {
            return;
        }
        Item[] armor = new Item[]{Items.field_151024_Q, Items.field_151028_Y, Items.field_151169_ag, Items.field_151161_ac, Items.field_151020_U, Items.field_151027_R, Items.field_151030_Z, Items.field_151171_ah, Items.field_151163_ad, Items.field_151023_V, Items.field_151026_S, Items.field_151165_aa, Items.field_151149_ai, Items.field_151173_ae, Items.field_151022_W, Items.field_151021_T, Items.field_151167_ab, Items.field_151151_aj, Items.field_151175_af, Items.field_151029_X};
        for (i = 0; i < 5; ++i) {
            Armory.register(armor[i], DICT_KEY_HELMET, "helmet");
        }
        while (i < 10) {
            Armory.register(armor[i], DICT_KEY_CHESTPLATE, "chestplate");
            ++i;
        }
        while (i < 15) {
            Armory.register(armor[i], DICT_KEY_LEGGINGS, "leggings");
            ++i;
        }
        while (i < 20) {
            Armory.register(armor[i], DICT_KEY_BOOTS, "boots");
            ++i;
        }
        for (i = 0; i < armor.length; ++i) {
            Armory.register(armor[i], DICT_KEY_ARMOR, "armor");
        }
        Armory.register(Items.field_185159_cQ, DICT_KEY_SHIELD, "shield");
        _DICT_IDS_INITED = true;
    }

    public static final boolean isLiningAllowed(ItemStack stack) {
        return !ItemStacks.isEmpty(stack) && stack.func_77973_b() instanceof ItemArmor;
    }

    private static final boolean hasLining(ItemStack stack, String NBT_TAGNAME) {
        boolean has = false;
        if (!ItemStacks.isEmpty(stack) && stack.func_77942_o()) {
            has = !stack.func_77978_p().func_74779_i(NBT_TAGNAME).isEmpty();
        }
        return has;
    }

    private static final void removeChecked(ItemStack armor, String NBT_TAGNAME) {
        if (armor.func_77942_o()) {
            armor.func_77978_p().func_82580_o(NBT_TAGNAME);
            if (armor.func_77978_p().func_82582_d()) {
                armor.func_77982_d(null);
            }
        }
    }

    @Nonnull
    private static final <T extends Enum<?>> ItemStack setLining(ItemStack armor, String NBT_TAGNAME, @Nullable T lining) {
        ItemStack out = ItemStack.field_190927_a;
        if (!ItemStacks.isEmpty(armor)) {
            if (lining == null || "NONE".equals(lining.name())) {
                Armory.removeChecked(armor, NBT_TAGNAME);
            } else {
                String id = lining.name();
                ItemStacks.getTagCompoundNonNull(armor).func_74778_a(NBT_TAGNAME, id);
            }
            out = armor;
        }
        return out;
    }

    public static final boolean hasXLining(ItemStack armor) {
        return Armory.hasLining(armor, XLining.NBT_TAGNAME);
    }

    @Nonnull
    public static final XLining.Def getXLining(ItemStack stack) {
        String id;
        XLining lining;
        XLining.Def defn = XLining.NO_DEF;
        if (Armory.isLiningAllowed(stack) && stack.func_77942_o() && (lining = XLining.findOrNone(id = stack.func_77978_p().func_74779_i(XLining.NBT_TAGNAME))) != XLining.NONE) {
            int val = 0;
            if (lining.hasValues()) {
                val = stack.func_77978_p().func_74762_e(XLining.NBT_VALUE_TAGNAME);
            }
            defn = new XLining.Def(lining, val);
        }
        return defn;
    }

    public static final boolean hasXLining(@Nullable XLining type, ItemStack stack) {
        XLining.Def has = Armory.getXLining(stack);
        return has.isEmpty() ? type == null || type == XLining.NONE : has.name == type;
    }

    @Nonnull
    public static final ItemStack setXLining(ItemStack armor, @Nullable XLining.Def defn) {
        if (ItemStacks.isEmpty(armor)) {
            return armor;
        }
        boolean removing = defn == null || defn.isEmpty();
        XLining lining = removing ? null : defn.name;
        if ((armor = Armory.setLining(armor, XLining.NBT_TAGNAME, lining)).func_77942_o()) {
            if (removing) {
                Armory.removeChecked(armor, XLining.NBT_VALUE_TAGNAME);
            } else if (lining.hasValues()) {
                armor.func_77978_p().func_74768_a(XLining.NBT_VALUE_TAGNAME, defn.value);
            } else {
                armor.func_77978_p().func_82580_o(XLining.NBT_VALUE_TAGNAME);
            }
        }
        return armor;
    }

    public static final boolean hasTLining(ItemStack armor) {
        return Armory.hasLining(armor, TLining.NBT_TAGNAME);
    }

    @Nonnull
    public static final TLining getTLining(ItemStack armor) {
        String id;
        TLining found = TLining.NONE;
        if (!ItemStacks.isEmpty(armor) && armor.func_77942_o() && !(id = armor.func_77978_p().func_74779_i(TLining.NBT_TAGNAME)).isEmpty()) {
            found = TLining.findOrNone(id);
        }
        return found;
    }

    @Nonnull
    public static final ItemStack setTLining(ItemStack armor, @Nullable TLining lining) {
        if (lining == TLining.NONE) {
            lining = null;
        }
        return Armory.setLining(armor, TLining.NBT_TAGNAME, lining);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static final String getTLiningTooltip(ItemStack stack) {
        TLining lining;
        String tooltip = null;
        if (Armory.isLiningAllowed(stack) && (lining = Armory.getTLining(stack)) != TLining.NONE) {
            boolean cooling = lining.getModifier() < 0;
            String modifierstring = "" + (cooling ? "-" : "+") + Math.abs(lining.getModifier());
            String description = Strings.translateFormatted("carrots.tooltip.tan.xlining." + (cooling ? "COOL" : "WARM"), modifierstring);
            TextFormatting color = cooling ? TextFormatting.DARK_AQUA : TextFormatting.DARK_RED;
            tooltip = "" + color + description + TextFormatting.RESET;
        }
        return tooltip;
    }

    public static final boolean hasLining(ItemStack armor) {
        return Armory.hasTLining(armor) || Armory.hasXLining(armor);
    }

    @Nonnull
    public static final String getArmorMaterialName(@Nullable ItemArmor.ArmorMaterial material) {
        String name = "";
        if (material != null) {
            try {
                return (String)ReflectionHelper.getPrivateValue(ItemArmor.ArmorMaterial.class, (Object)material, (String[])new String[]{"name", "field_179243_f"});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return name;
    }

    public static final void hideStandardModifierRender(@Nonnull ItemStack on) {
        if (on.func_77942_o()) {
            int current = on.func_77978_p().func_74762_e(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME());
            on.func_77978_p().func_74768_a(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME(), current | 2);
        }
    }

    public static final String getWeaponOrToolModifierName(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemTool ? SharedGlue.TOOL_MODIFIER_ATTRNAME() : SharedGlue.WEAPON_MODIFIER_ATTRNAME();
    }

    public static final boolean hasModifiedAttributes(ItemStack stack) {
        return !ItemStacks.isEmpty(stack) && stack.func_77942_o() && stack.func_77978_p().func_150297_b(SharedGlue.CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME(), 9);
    }

    public static final boolean hasReforgedAttributes(ItemStack stack) {
        return Instructions.isLooted(stack) && Armory.hasModifiedAttributes(stack) && (stack.func_77978_p().func_74762_e(SharedGlue.ITEM_INFO_HIDDEN_TAGNAME()) & 2) == 2;
    }

    public static final void removeModifiedAttributes(ItemStack stack) {
        if (!ItemStacks.isEmpty(stack) && stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(SharedGlue.CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME());
        }
    }

    public static final void removeModifiedAttributes(ItemStack stack, String ... attributeNames) {
        if (attributeNames.length > 0 && Armory.hasModifiedAttributes(stack)) {
            NBTTagList list = stack.func_77978_p().func_150295_c(SharedGlue.CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME(), 10);
            Iterator litr = list.iterator();
            block0: while (litr.hasNext()) {
                NBTTagCompound modNbt = (NBTTagCompound)litr.next();
                String am_id = modNbt.func_74779_i("AttributeName");
                for (String attrid : attributeNames) {
                    if (!attrid.equals(am_id)) continue;
                    litr.remove();
                    continue block0;
                }
            }
            if (list.func_82582_d()) {
                stack.func_77978_p().func_82580_o(SharedGlue.CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME());
            }
        }
    }

    @Nonnull
    public static final String getModifiersProfileId(@Nonnull ItemStack stack) {
        String id = "";
        if (!stack.func_190926_b() && stack.func_77942_o() && (id = stack.func_77978_p().func_74779_i("StatsProfile")).isEmpty() && Instructions.present(stack)) {
            id = Instructions.get(stack).func_74779_i("StatsProfile");
        }
        return id;
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addWeaponModifierInformation(@Nonnull ItemStack stack, @Nullable EntityPlayer player, @Nonnull List<String> tooltip) {
        if (player != null) {
            Armory.addModifierInformation(stack, player, _MAINHAND_ONLY, tooltip);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addWeaponModifierInformation(@Nonnull ItemStack stack, @Nonnull List<String> tooltip) {
        Armory.addModifierInformation(stack, null, _MAINHAND_ONLY, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public static final void addModifierInformation(@Nonnull ItemStack stack, @Nullable EntityPlayer player, @Nonnull EntityEquipmentSlot[] slots, @Nonnull List<String> tooltip) {
        for (EntityEquipmentSlot slot : slots) {
            Multimap slotattrs = stack.func_111283_C(slot);
            if (slotattrs.isEmpty()) continue;
            tooltip.add("");
            tooltip.add(Strings.translate("item.modifiers." + slot.func_188450_d()));
            boolean reforged_label = false;
            int reforged_label_index = -1;
            for (int pass = 0; pass < 2; ++pass) {
                for (Map.Entry entry : slotattrs.entries()) {
                    double final_amount;
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    int op = modifier.func_111169_c();
                    double amount = modifier.func_111164_d();
                    boolean actual = false;
                    if (UUIDPeek.isAttackDamage(modifier.func_111167_a())) {
                        actual = true;
                        if (pass == 0) {
                            amount += player != null ? player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() : 1.0;
                            amount += (double)EnchantmentHelper.func_152377_a((ItemStack)stack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
                        }
                    } else if (UUIDPeek.isAttackSpeedo(modifier.func_111167_a())) {
                        actual = true;
                        if (pass == 0) {
                            amount += player != null ? player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b() : SharedMonsterAttributes.field_188790_f.func_111110_b();
                        }
                    }
                    double d = final_amount = Armory.isPercentageOp(op) ? 100.0 * amount : amount;
                    if (pass == 0 && actual) {
                        tooltip.add(" " + Strings.translateFormatted("attribute.base_modifier.equals." + op, _VALFMT.format(final_amount), Strings.translate("attribute.name." + (String)entry.getKey())));
                        continue;
                    }
                    if (pass == 0 || actual) continue;
                    if (!reforged_label) {
                        reforged_label = true;
                        tooltip.add("");
                        tooltip.add(Strings.translate("tooltip.section.reforged.results"));
                        reforged_label_index = tooltip.size() - 1;
                        tooltip.add(" " + Strings.translate("item.modifiers." + slot.func_188450_d()));
                    }
                    if (amount > 0.0) {
                        tooltip.add(TextFormatting.BLUE + "  " + Strings.translateFormatted("attribute.modifier.plus." + op, _VALFMT.format(final_amount), Strings.translate("attribute.name." + (String)entry.getKey())));
                        continue;
                    }
                    if (!(amount < 0.0)) continue;
                    tooltip.add(TextFormatting.RED + "  " + Strings.translateFormatted("attribute.modifier.take." + op, _VALFMT.format(final_amount *= -1.0), Strings.translate("attribute.name." + (String)entry.getKey())));
                }
            }
            if (!reforged_label) continue;
            String marker = tooltip.get(reforged_label_index);
            if (marker.indexOf(45) >= 0) {
                int width;
                int markerwidth;
                FontRenderer fontRenderer = stack.func_77973_b().getFontRenderer(stack);
                if (fontRenderer == null) {
                    fontRenderer = Minecraft.func_71410_x().field_71466_p;
                }
                int maxwidth = markerwidth = fontRenderer.func_78256_a(marker);
                for (String line : tooltip) {
                    width = fontRenderer.func_78256_a(line);
                    if (width <= maxwidth) continue;
                    maxwidth = width;
                }
                if (maxwidth != markerwidth) {
                    int x = marker.indexOf(45);
                    StringBuilder sb = new StringBuilder(300);
                    width = 0;
                    sb.append(marker.substring(0, x));
                    do {
                        sb.append("-");
                    } while ((width = fontRenderer.func_78256_a(sb.toString())) < maxwidth && width < 300);
                    marker = sb.toString();
                }
            }
            tooltip.set(reforged_label_index, TextFormatting.DARK_PURPLE + marker + TextFormatting.RESET);
        }
    }

    private static boolean isPercentageOp(int op) {
        return op == 1 || op == 2;
    }

    public static final boolean isDefendableAgainst(@Nonnull DamageSource with) {
        String name = with.func_76355_l();
        return "mob".equals(name) || "player".equals(name) || "thrown".equals(name) || with instanceof EntityDamageSource || with instanceof EntityDamageSourceIndirect;
    }

    public static final boolean isDirectPlayerAttackDamage(DamageSource ds) {
        return ds instanceof EntityDamageSource && "player".equals(ds.func_76355_l()) && SharedGlue.isRealPlayer(ds.func_76364_f());
    }

    public static final boolean isDirectMonsterAttackDamage(DamageSource ds) {
        return ds instanceof EntityDamageSource && "mob".equals(ds.func_76355_l()) && SharedGlue.isMonsterOrPiOoed(ds.func_76364_f());
    }

    public static final boolean isDirectEntityAttackDamage(DamageSource ds) {
        return Armory.isDirectPlayerAttackDamage(ds) || Armory.isDirectMonsterAttackDamage(ds);
    }

    public static final boolean isDamageAbsolute(DamageSource with) {
        boolean is = with.func_151517_h();
        if (is && Armory.isDefendableAgainst(with)) {
            is = false;
        }
        return is;
    }

    public static final boolean attemptDamageItemBounded(ItemStack armor, int amount, @Nonnull EntityLivingBase bearer) {
        boolean attempted = false;
        if (!ItemStacks.isEmpty(armor)) {
            int current_damage;
            if (SharedGlue.isaPlayer((Entity)bearer) && (current_damage = armor.func_77952_i()) + amount >= armor.func_77958_k()) {
                amount = armor.func_77958_k() - current_damage - 1;
            }
            if (amount > 0) {
                armor.func_77972_a(amount, bearer);
                attempted = true;
            }
        }
        return attempted;
    }

    private Armory() {
    }

    public static final void init() {
    }

    public static final class UUIDPeek
    extends Item {
        public static final UUID getAttackDamageUUID() {
            return Item.field_111210_e;
        }

        public static final UUID getAttackSpeedoUUID() {
            return Item.field_185050_h;
        }

        public static final boolean isAttackDamage(String uuidstring) {
            return UUIDPeek.getAttackDamageUUID().toString().equals(uuidstring);
        }

        public static final boolean isAttackDamage(UUID uuid) {
            return uuid != null && (uuid == Item.field_111210_e || UUIDPeek.isAttackDamage(uuid.toString()));
        }

        public static final boolean isAttackSpeedo(String uuidstring) {
            return UUIDPeek.getAttackSpeedoUUID().toString().equals(uuidstring);
        }

        public static final boolean isAttackSpeedo(UUID uuid) {
            return uuid != null && (uuid == Item.field_185050_h || UUIDPeek.isAttackSpeedo(uuid.toString()));
        }

        private UUIDPeek() {
        }
    }

    public static enum TLining {
        COOLEST(-3),
        COOLER(-2),
        COOL(-1),
        NONE(0),
        WARM(1),
        WARMER(2),
        WARMEST(3);

        private static final TLining[] _VALUES;
        public static final String NBT_TAGNAME;
        private final int _modifier;

        private TLining(int modifier) {
            this._modifier = modifier;
        }

        public final boolean isEmpty() {
            return this == NONE;
        }

        public int getModifier() {
            return this._modifier;
        }

        public int getOffsetModifier() {
            return this.ordinal() - NONE.ordinal();
        }

        public int getThickness() {
            return Math.abs(this.getOffsetModifier());
        }

        public int getDirection() {
            return Integer.compare(this.ordinal(), NONE.ordinal());
        }

        @Nonnull
        public static final TLining findOrNone(@Nonnull String id) {
            id = id.toUpperCase(Locale.US);
            for (TLining lining : _VALUES) {
                if (!lining.name().equals(id)) continue;
                return lining;
            }
            return NONE;
        }

        @Nonnull
        public final TLining adjust(int delta) {
            int to = this.ordinal() + delta;
            for (int i = 0; i < _VALUES.length; ++i) {
                if (to != _VALUES[i].ordinal()) continue;
                return _VALUES[i];
            }
            return to <= COOLEST.ordinal() ? COOLEST : WARMEST;
        }

        static {
            _VALUES = TLining.values();
            NBT_TAGNAME = LibInfo.rstring("ArmorTLining");
        }
    }

    public static enum XLining {
        NONE(-1),
        TEMPERATURE_REGULATOR(3),
        OBSIDIAN_SHIELD(0),
        ANTIFREEZE_SHIELD(0),
        PHOTOSYNTHETIC(0),
        ANTI_CORROSIVE(0),
        SHOCK_ABSORBER(2),
        DEFRACTION_CLOAK(0);

        private static final XLining[] _VALUES;
        public static final String NBT_TAGNAME;
        public static final String NBT_VALUE_TAGNAME;
        private final int _val_count;
        public static final Def NO_DEF;

        private XLining(int value_count) {
            this._val_count = value_count;
        }

        public boolean hasValues() {
            return this._val_count > 0;
        }

        @Nonnull
        public static final XLining findOrNone(@Nonnull String id) {
            if (!id.isEmpty()) {
                id = id.toUpperCase(Locale.US);
                for (XLining lining : _VALUES) {
                    if (!lining.name().equals(id)) continue;
                    return lining;
                }
            }
            return NONE;
        }

        static {
            _VALUES = XLining.values();
            NBT_TAGNAME = LibInfo.rstring("ArmorXLining");
            NBT_VALUE_TAGNAME = LibInfo.rstring("ArmorXLining_value");
            NO_DEF = new Def(NONE, 0);
        }

        public static final class Def {
            public final XLining name;
            public final int value;

            public Def(@Nonnull XLining id, int i) {
                this.name = id == null ? NONE : id;
                this.value = i;
            }

            public Def(@Nonnull XLining id) {
                this(id, 0);
            }

            public final boolean isEmpty() {
                return this.name == NONE;
            }

            public String toString() {
                return "" + (Object)((Object)this.name) + (this.isEmpty() ? "" : ":" + this.value);
            }
        }
    }
}

